const menus = [
  {
    name: 'dashboard',
    route: 'dashboard',
    icon: 'home',
    hidden: false,
    heading: 'Main',
    sub_menu: false,
    permissions: ['all'],
    lang: { helper: null, main: 'Dashboard' },
  },
  {
    name: 'checkins',
    route: null,
    icon: 'in',
    hidden: false,
    heading: null,
    children: ['checkins'],
    lang: { helper: null, main: 'Checkins' },
    permissions: ['read-checkins', 'create-checkins', 'update-checkins'],
    sub_menu: [
      {
        name: 'checkins.list',
        route: 'checkins.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'checkins',
        permissions: ['read-checkins'],
        lang: { helper: 'list_x', main: 'Checkins' },
      },
      {
        name: 'checkins.create',
        route: 'checkins.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'checkins',
        permissions: ['create-checkins'],
        lang: { helper: 'create_x', main: 'Checkin' },
      },
    ],
  },
  {
    name: 'checkouts',
    route: null,
    icon: 'out',
    hidden: false,
    heading: null,
    children: ['checkouts'],
    lang: { helper: null, main: 'Checkouts' },
    permissions: ['read-checkouts', 'create-checkouts', 'update-checkouts'],
    sub_menu: [
      {
        name: 'checkouts.list',
        route: 'checkouts.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'checkouts',
        permissions: ['read-checkouts'],
        lang: { helper: 'list_x', main: 'Checkouts' },
      },
      {
        name: 'checkouts.create',
        route: 'checkouts.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'checkouts',
        permissions: ['create-checkouts'],
        lang: { helper: 'create_x', main: 'Checkout' },
      },
    ],
  },
  {
    name: 'adjustments',
    route: null,
    icon: 'adjustments',
    hidden: false,
    heading: null,
    children: ['adjustments'],
    lang: { helper: null, main: 'Adjustments' },
    permissions: ['read-adjustments'],
    sub_menu: [
      {
        name: 'adjustments.list',
        route: 'adjustments.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['read-adjustments'],
        lang: { main: 'Adjustments' },
      },
      {
        name: 'adjustments.create',
        route: 'adjustments.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'adjustments',
        permissions: ['create-adjustments'],
        lang: { helper: 'create_x', main: 'Adjustment' },
      },
    ],
  },
  {
    name: 'transfers',
    route: null,
    icon: 'truck',
    hidden: false,
    heading: null,
    children: ['transfers'],
    lang: { helper: null, main: 'Transfers' },
    permissions: ['read-transfers'],
    sub_menu: [
      {
        name: 'transfers.list',
        route: 'transfers.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['read-transfers'],
        lang: { main: 'Transfers' },
      },
      {
        name: 'transfers.create',
        route: 'transfers.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'transfers',
        permissions: ['create-transfers'],
        lang: { helper: 'create_x', main: 'Transfer' },
      },
    ],
  },
  {
    name: 'items',
    route: null,
    icon: 'heart',
    hidden: false,
    heading: null,
    children: ['items'],
    lang: { helper: null, main: 'Items' },
    permissions: ['read-items', 'create-items', 'update-items'],
    sub_menu: [
      {
        name: 'items.list',
        route: 'items.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'items',
        permissions: ['read-items'],
        lang: { helper: 'list_x', main: 'Items' },
      },
      {
        name: 'items.create',
        route: 'items.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'items',
        permissions: ['create-items'],
        lang: { helper: 'create_x', main: 'Item' },
      },
      {
        name: 'items.import',
        route: 'items.import',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'items',
        permissions: ['import-items'],
        lang: { helper: 'import_x', main: 'Items' },
      },
    ],
  },
  {
    name: 'contacts',
    route: null,
    icon: 'group',
    hidden: false,
    heading: null,
    children: ['contacts'],
    lang: { helper: null, main: 'Contacts' },
    permissions: ['read-contacts', 'create-contacts', 'update-contacts'],
    sub_menu: [
      {
        name: 'contacts.list',
        route: 'contacts.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'contacts',
        permissions: ['read-contacts'],
        lang: { helper: 'list_x', main: 'Contacts' },
      },
      {
        name: 'contacts.create',
        route: 'contacts.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'contacts',
        permissions: ['create-contacts'],
        lang: { helper: 'create_x', main: 'Contact' },
      },
      {
        name: 'contacts.import',
        route: 'contacts.import',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'contacts',
        permissions: ['import-contacts'],
        lang: { helper: 'import_x', main: 'Contacts' },
      },
    ],
  },
  {
    name: 'categories',
    route: null,
    icon: 'collection',
    hidden: false,
    heading: null,
    children: ['categories'],
    lang: { helper: null, main: 'Categories' },
    permissions: ['read-categories', 'create-categories', 'update-categories'],
    sub_menu: [
      {
        name: 'categories.list',
        route: 'categories.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'categories',
        permissions: ['read-categories'],
        lang: { helper: 'list_x', main: 'Categories' },
      },
      {
        name: 'categories.create',
        route: 'categories.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'categories',
        permissions: ['create-categories'],
        lang: { helper: 'create_x', main: 'Category' },
      },
      {
        name: 'categories.import',
        route: 'categories.import',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'categories',
        permissions: ['import-categories'],
        lang: { helper: 'import_x', main: 'Categories' },
      },
    ],
  },
  {
    name: 'units',
    route: null,
    icon: 'chip',
    hidden: false,
    heading: null,
    children: ['units'],
    lang: { helper: null, main: 'Units' },
    permissions: ['read-units', 'create-units', 'update-units'],
    sub_menu: [
      {
        name: 'units.list',
        route: 'units.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'units',
        permissions: ['read-units'],
        lang: { helper: 'list_x', main: 'Units' },
      },
      {
        name: 'units.create',
        route: 'units.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'units',
        permissions: ['create-units'],
        lang: { helper: 'create_x', main: 'Unit' },
      },
      {
        name: 'units.import',
        route: 'units.import',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'units',
        permissions: ['import-units'],
        lang: { helper: 'import_x', main: 'Units' },
      },
    ],
  },
  {
    name: 'warehouses',
    route: null,
    icon: 'building',
    hidden: false,
    heading: null,
    children: ['warehouses'],
    lang: { helper: null, main: 'Warehouses' },
    permissions: ['read-warehouses', 'create-warehouses', 'update-warehouses'],
    sub_menu: [
      {
        name: 'warehouses.list',
        route: 'warehouses.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'warehouses',
        permissions: ['read-warehouses'],
        lang: { helper: 'list_x', main: 'Warehouses' },
      },
      {
        name: 'warehouses.create',
        route: 'warehouses.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'warehouses',
        permissions: ['create-warehouses'],
        lang: { helper: 'create_x', main: 'Warehouse' },
      },
      {
        name: 'warehouses.import',
        route: 'warehouses.import',
        icon: null,
        hidden: false,
        sub_menu: false,
        target: 'warehouses',
        permissions: ['import-warehouses'],
        lang: { helper: 'import_x', main: 'Warehouses' },
      },
    ],
  },
  {
    name: 'users',
    route: null,
    icon: 'users',
    hidden: false,
    heading: null,
    children: ['users', 'roles'],
    lang: { helper: null, main: 'Users' },
    permissions: ['read-users', 'create-users', 'update-users', 'read-roles', 'create-roles', 'update-roles'],
    sub_menu: [
      {
        name: 'users.list',
        route: 'users.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['read-users'],
        lang: { helper: 'list_x', main: 'Users' },
      },
      {
        name: 'users.create',
        route: 'users.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['create-users'],
        lang: { helper: 'create_x', main: 'User' },
      },
      {
        name: 'roles.list',
        route: 'roles.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['read-roles'],
        lang: { helper: 'list_x', main: 'Roles' },
      },
      {
        name: 'roles.create',
        route: 'roles.create',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['create-roles'],
        lang: { helper: 'create_x', main: 'Role' },
      },
    ],
  },
  {
    name: 'reports',
    route: null,
    icon: 'chart-bar',
    hidden: false,
    heading: null,
    children: ['reports'],
    lang: { helper: null, main: 'Reports' },
    permissions: ['read-reports'],
    sub_menu: [
      {
        name: 'reports.list',
        route: 'reports.index',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['read-reports'],
        lang: { main: 'Total Records' },
      },
      {
        name: 'reports.checkin',
        route: 'reports.checkin',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['checkin-reports'],
        lang: { helper: 'x_report', main: 'Checkin' },
      },
      {
        name: 'reports.checkout',
        route: 'reports.checkout',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['checkout-reports'],
        lang: { helper: 'x_report', main: 'Checkout' },
      },
      {
        name: 'reports.transfer',
        route: 'reports.transfer',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['transfer-reports'],
        lang: { helper: 'x_report', main: 'Transfer' },
      },
      {
        name: 'reports.adjustment',
        route: 'reports.adjustment',
        icon: null,
        hidden: false,
        sub_menu: false,
        permissions: ['adjustment-reports'],
        lang: { helper: 'x_report', main: 'Adjustment' },
      },
    ],
  },
  {
    name: 'activity',
    route: 'activity',
    icon: 'doc-text',
    hidden: false,
    heading: 'Misc',
    sub_menu: false,
    permissions: ['read-activity'],
    lang: { helper: null, main: 'Activity' },
  },
];
export default menus;
