<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\URL;

function translations($json) {
    if(!file_exists($json)) {
        return [];
    }
    return is_string(file_get_contents($json)) ? json_decode(file_get_contents($json), true) : file_get_contents($json);
}

if (!function_exists('static_asset')) {
    /**
     * Generate an asset path for the application.
     *
     * @param string $path
     * @param bool|null $secure
     * @return string
     */
    function static_asset($path, $secure = null) {
        return app('url')->asset('public/' . $path, $secure);
    }
}

function isActive($route, $className = 'active') {
    if (is_array($route)) {
        return in_array(Route::currentRouteName(), $route) ? $className : '';
    }
    if (Route::currentRouteName() == $route) {
        return $className;
    }
    if (strpos(URL::current(), $route)) {
        return $className;
    }
}
