import { L as Layout } from "./Layout-p-cBGERf.js";
import { Link, Head } from "@inertiajs/vue3";
import moment_timezone from "moment-timezone";
import Datepicker from "@vuepic/vue-datepicker";
/* empty css              */
import { ref, resolveComponent, mergeProps, useSSRContext } from "vue";
import { B as BoardViewMenu } from "./BoardViewMenu-DKT5LdJ5.js";
import { Qalendar } from "qalendar";
import throttle from "lodash/throttle.js";
import pickBy from "lodash/pickBy.js";
import { ssrRenderAttrs, ssrRenderComponent } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./FlashMessages-DizfipYZ.js";
import "@popperjs/core";
import "axios";
import "uuid";
import "moment";
import "moment-duration-format";
import "laravel-vue-i18n";
const _sfc_main = {
  metaInfo: { title: "FAQs" },
  components: {
    Link,
    Head,
    Datepicker,
    Qalendar,
    BoardViewMenu
  },
  layout: Layout,
  props: {
    auth: Object,
    title: String,
    tasks: Object,
    filters: Object,
    project: Object,
    list_index: Object,
    board_lists: Object,
    lists: {
      required: false
    }
  },
  watch: {
    form: {
      deep: true,
      handler: throttle(function() {
        this.$inertia.get(this.route("projects.view.calendar", this.project.slug || this.project.id), pickBy(this.form), { preserveState: true });
      }, 150)
    }
  },
  remember: "form",
  setup() {
    let dateOverride = ref(null);
    const closeOverrideCalendar = () => {
      if (!!dateOverride.value && dateOverride.value.length) {
        dateOverride.value[0].closeMenu();
      }
    };
    return {
      dateOverride,
      closeOverrideCalendar
    };
  },
  data() {
    return {
      calendarView: false,
      open_filter: false,
      calendarEvents: [],
      evConfig: {
        style: {
          colorSchemes: {}
        },
        week: {
          // Takes the value 'sunday' or 'monday'
          // However, if startsOn is set to 'sunday' and nDays to 5, the week displayed will be Monday - Friday
          startsOn: "monday",
          // Takes the values 5 or 7.
          nDays: 7,
          // Scroll to a certain hour on mounting a week. Takes any value from 0 to 23.
          // This option is not compatible with the 'dayBoundaries'-option, and will simply be ignored if custom day boundaries are set.
          scrollToHour: 5,
          weekHeight: "3400px"
        },
        month: {
          // Hide leading and trailing dates in the month view (defaults to true when not set)
          showTrailingAndLeadingDates: false
        },
        // defaultMode: this.filters.view || 'week',
        defaultMode: "week",
        // The silent flag can be added, to disable the development warnings. This will also bring a slight performance boost
        isSilent: true,
        showCurrentTime: true
        // Display a line indicating the current time
      },
      form: {
        search: this.filters.search,
        trashed: this.filters.trashed,
        view: ["calendar"].includes(this.filters.period) ? this.filters.view : null,
        range: ["range", "calendar"].includes(this.filters.period) ? this.filters.range : null
      },
      event_dates: {},
      rangeDate: null
    };
  },
  methods: {
    crossEvent(id) {
      const findCrossEventIndex = this.events.data.findIndex((e) => e.id = id);
      console.log(findCrossEventIndex);
      this.events.data[findCrossEventIndex].is_active = false;
    },
    getRequestDate() {
      return /* @__PURE__ */ new Date();
    },
    selectRange() {
      console.log(this.rangeDate);
      this.form.range = { start: this.rangeDate[0], end: this.rangeDate[1] };
      this.form.period = "range";
    },
    activeTab(index) {
      for (const tab_item of this.tabs) {
        tab_item.active = false;
      }
      if (this.tabs[index].period === "range")
        ;
      else {
        this.form.period = this.tabs[index].period;
      }
    },
    filter() {
    },
    handleDateUpdate(obj) {
      this.form.range = { start: this.moment(obj.start).format("YYYY-MM-DD"), end: this.moment(obj.end).format("YYYY-MM-DD") };
      this.form.period = "calendar";
      this.form.view = this.filters.view || "week";
    },
    handleModeUpdate(obj) {
      this.form.range = { start: this.moment(obj.period.start).format("YYYY-MM-DD"), end: this.moment(obj.period.end).format("YYYY-MM-DD") };
      this.form.view = obj.mode;
    },
    processData() {
      this.event_dates = {};
      for (const event_item of this.tasks) {
        const created_at = this.moment(event_item.created_at || event_item.updated_at, "YYYY-MM-DD HH:mm:ss").format("YYYY-MM-DD HH:mm");
        const due_date = event_item.due_date ? this.moment(event_item.due_date, "YYYY-MM-DD HH:mm:ss").format("YYYY-MM-DD HH:mm") : "";
        let html = "";
        html += '<span><a href="/p/board/' + event_item.project_id + "?task=" + event_item.id + '">' + event_item.title + "</a></span>";
        html += '<span><strong>Board:</strong> <a href="/p/board/' + event_item.project_idet + '">' + (event_item.list ? event_item.list.title : "") + "</a></span>";
        html += "<span><strong>Created At:</strong> " + this.moment(event_item.created_at || event_item.updated_at, "YYYY-MM-DD HH:mm:ss").format("Do MMMM, YYYY") + "</span>";
        if (due_date) {
          html += "<span><strong>Due Date:</strong> " + this.moment(event_item.due_date, "YYYY-MM-DD HH:mm:ss").format("Do MMMM, YYYY") + "</span>";
        }
        this.calendarEvents.push({
          title: (event_item.list ? event_item.list.title + " : " : "") + event_item.title,
          time: { start: created_at, end: due_date || created_at },
          description: html,
          // time: { start: this.moment(event_item.date+' '+event_item.start, 'YYYY-MM-DD h:mma').format('YYYY-MM-DD HH:mm'), end: this.moment(event_item.date+' '+event_item.end, 'YYYY-MM-DD h:mma').format('YYYY-MM-DD HH:mm') },
          // colorScheme: event_item.color?event_item.uid: null,
          id: event_item.id
        });
      }
      this.calendarView = true;
    }
  },
  mounted() {
    this.processData();
  },
  created() {
    this.moment = moment_timezone;
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Head = resolveComponent("Head");
  const _component_board_view_menu = resolveComponent("board-view-menu");
  const _component_Qalendar = resolveComponent("Qalendar");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "h-full" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_Head, {
    title: _ctx.$t($props.title)
  }, null, _parent));
  _push(`<div class="flex flex-col flex-grow-1 flex-shrink-1 h-full">`);
  _push(ssrRenderComponent(_component_board_view_menu, {
    project: $props.project,
    onFilterToggle: ($event) => $data.open_filter = !$data.open_filter,
    filters: $props.filters,
    view: "calendar"
  }, null, _parent));
  _push(`<div class="flex flex-col task__table overflow-y-auto h-full"><div class="inline-block min-w-full h-full py-4 align-middle md:px-3 lg:px-4">`);
  if ($data.calendarView) {
    _push(`<div id="ec_module" class="calendar-container">`);
    _push(ssrRenderComponent(_component_Qalendar, {
      events: $data.calendarEvents,
      "selected-date": $options.getRequestDate(),
      config: $data.evConfig,
      onUpdatedPeriod: $options.handleDateUpdate,
      onUpdatedMode: $options.handleModeUpdate
    }, null, _parent));
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div></div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Projects/Calendar.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Calendar = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  Calendar as default
};
