import { Link, Head } from "@inertiajs/vue3";
import { I as Icon, S as SelectInput, L as Layout } from "./Layout-p-cBGERf.js";
import { P as Pagination } from "./Pagination-DBkwUgAS.js";
import { T as TextInput, L as LoadingButton } from "./LoadingButton-CYW6UWDJ.js";
import { v4 } from "uuid";
import { mergeProps, useSSRContext, resolveComponent, withCtx, openBlock, createBlock, Fragment, renderList, toDisplayString, createTextVNode } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import { F as FileInput } from "./FileInput-PDHMJZ8j.js";
import "./FlashMessages-DizfipYZ.js";
import "@popperjs/core";
import "axios";
import "moment";
import "moment-duration-format";
import "laravel-vue-i18n";
const _sfc_main$1 = {
  inheritAttrs: false,
  props: {
    id: {
      type: String,
      default() {
        return `textarea-input-${v4()}`;
      }
    },
    error: String,
    label: String,
    modelValue: String,
    rows: {
      type: Number,
      default: 3
    }
  },
  emits: ["update:modelValue"],
  methods: {
    focus() {
      this.$refs.input.focus();
    },
    select() {
      this.$refs.input.select();
    }
  }
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  let _temp0;
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: _ctx.$attrs.class
  }, _attrs))}>`);
  if ($props.label) {
    _push(`<label class="form-label"${ssrRenderAttr("for", $props.id)}>${ssrInterpolate($props.label)}</label>`);
  } else {
    _push(`<!---->`);
  }
  _push(`<textarea${ssrRenderAttrs(_temp0 = mergeProps({
    id: $props.id,
    ref: "input"
  }, { ..._ctx.$attrs, class: null }, {
    class: ["form-textarea", { error: $props.error }],
    rows: $props.rows,
    value: $props.modelValue
  }), "textarea")}>${ssrInterpolate("value" in _temp0 ? _temp0.value : "")}</textarea>`);
  if ($props.error) {
    _push(`<div class="form-error">${ssrInterpolate($props.error)}</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/TextareaInput.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const TextareaInput = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main = {
  metaInfo: { title: "Priorities" },
  components: {
    Icon,
    Link,
    Head,
    FileInput,
    Pagination,
    TextInput,
    TextareaInput,
    SelectInput,
    LoadingButton
  },
  layout: Layout,
  props: {
    title: String,
    settings: Object,
    languages: Array,
    pusher: Boolean,
    site_key: String,
    webhook_url: String
  },
  remember: "form",
  data() {
    return {
      availableFileTypes: [
        "pdf",
        "doc",
        "docx",
        "xls",
        "xlsx",
        "ppt",
        "pptx",
        "txt",
        "csv",
        "jpg",
        "jpeg",
        "png",
        "gif",
        "webp",
        "svg",
        "mp3",
        "wav",
        "mp4",
        "webm",
        "zip",
        "rar",
        "7z"
      ],
      newFileType: "",
      form: this.$inertia.form({
        app_name: this.settings.app_name.value,
        enable_registration: Boolean(parseInt(this.settings.enable_registration.value, 10)),
        logo: null,
        logo_white: null,
        favicon: null,
        site_key: this.site_key,
        webhook_url: this.webhook_url || "",
        main_logo: "/images/logo.png",
        main_logo_white: "/images/logo_white.png",
        main_favicon: "/favicon.png",
        default_language: this.settings.default_language.value,
        custom_css: typeof this.settings.custom_css !== "undefined" && this.settings.custom_css ? this.settings.custom_css.value : null,
        allowed_file_types: this.settings.allowed_file_types ? this.settings.allowed_file_types.value : [],
        email_notifications: this.settings.email_notifications.value.map((en) => {
          return { "name": en.name, "slug": en.slug, "value": !!en.value };
        }),
        slack_notifications: this.settings.slack_notifications.value.map((en) => {
          return { "name": en.name, "slug": en.slug, "value": !!en.value };
        })
      })
    };
  },
  created() {
  },
  methods: {
    update() {
      const vm = this;
      this.form.post(this.route("global.update"), {
        onSuccess: () => {
          const successMessage = vm.$page.props.flash.success;
          this.form.logo = null;
          this.form.logo_white = null;
          if (successMessage) {
            window.location.reload();
          }
        }
      });
    },
    addFileType() {
      const val = this.newFileType.trim().replace(/,/g, "");
      if (val && !this.form.allowed_file_types.includes(val)) {
        this.form.allowed_file_types.push(val);
      }
      this.newFileType = "";
    },
    checkDelimiter(e) {
      if (e.key === "," || e.key === " ") {
        e.preventDefault();
        this.addFileType();
      }
    },
    removeFileType(index) {
      this.form.allowed_file_types.splice(index, 1);
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Head = resolveComponent("Head");
  const _component_text_input = resolveComponent("text-input");
  const _component_select_input = resolveComponent("select-input");
  const _component_file_input = resolveComponent("file-input");
  const _component_icon = resolveComponent("icon");
  const _component_textarea_input = resolveComponent("textarea-input");
  const _component_loading_button = resolveComponent("loading-button");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "sec-cont" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_Head, { title: $props.title }, null, _parent));
  _push(`<div class="bg-white rounded-md shadow overflow-hidden mr-2"><form><div class="p-8 -mr-6 -mb-8 flex flex-wrap">`);
  _push(ssrRenderComponent(_component_text_input, {
    modelValue: $data.form.app_name,
    "onUpdate:modelValue": ($event) => $data.form.app_name = $event,
    error: $data.form.errors.app_name,
    class: "pr-6 pb-8 w-full lg:w-1/3",
    label: _ctx.$t("App Name")
  }, null, _parent));
  _push(ssrRenderComponent(_component_text_input, {
    modelValue: $data.form.site_key,
    "onUpdate:modelValue": ($event) => $data.form.site_key = $event,
    error: $data.form.errors.site_key,
    class: "pr-6 pb-8 w-full lg:w-1/3",
    label: _ctx.$t("Google ReCaptcha Site Key")
  }, null, _parent));
  _push(ssrRenderComponent(_component_select_input, {
    modelValue: $data.form.default_language,
    "onUpdate:modelValue": ($event) => $data.form.default_language = $event,
    error: $data.form.errors.default_language,
    class: "pr-6 pb-8 w-full lg:w-1/3",
    label: _ctx.$t("Default Language")
  }, {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<!--[-->`);
        ssrRenderList($props.languages, (l) => {
          _push2(`<option${ssrRenderAttr("value", l.code)}${_scopeId}>${ssrInterpolate(l.name)}</option>`);
        });
        _push2(`<!--]-->`);
      } else {
        return [
          (openBlock(true), createBlock(Fragment, null, renderList($props.languages, (l) => {
            return openBlock(), createBlock("option", {
              key: l.id,
              value: l.code
            }, toDisplayString(l.name), 9, ["value"]);
          }), 128))
        ];
      }
    }),
    _: 1
  }, _parent));
  _push(ssrRenderComponent(_component_text_input, {
    modelValue: $data.form.webhook_url,
    "onUpdate:modelValue": ($event) => $data.form.webhook_url = $event,
    error: $data.form.errors.webhook_url,
    class: "pb-8 w-full",
    label: _ctx.$t("Slack webhook URL")
  }, null, _parent));
  _push(`<div class="pb-8 pr-6 w-full flex lg:w-1/3">`);
  _push(ssrRenderComponent(_component_file_input, {
    modelValue: $data.form.favicon,
    "onUpdate:modelValue": ($event) => $data.form.favicon = $event,
    error: $data.form.errors.favicon,
    class: "pr-2 w-full lg:w-3/5",
    type: "file",
    accept: "image/png",
    label: "Favicon"
  }, null, _parent));
  _push(`<div class="w-full lg:w-2/5 flex items-end justify-start">`);
  if ($data.form.main_favicon) {
    _push(`<img class="block w-auto h-[30px]"${ssrRenderAttr("src", $data.form.main_favicon)}>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div><div class="pb-8 pr-6 w-full flex lg:w-1/3">`);
  _push(ssrRenderComponent(_component_file_input, {
    modelValue: $data.form.logo,
    "onUpdate:modelValue": ($event) => $data.form.logo = $event,
    error: $data.form.errors.logo,
    class: "pr-2 w-full lg:w-3/5",
    type: "file",
    accept: "image/png",
    label: "Logo"
  }, null, _parent));
  _push(`<div class="w-full lg:w-2/5 flex items-end justify-start">`);
  if ($data.form.main_logo) {
    _push(`<img class="block w-auto h-[30px] rounded"${ssrRenderAttr("src", $data.form.main_logo)}>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div><div class="pb-8 pr-6 w-full flex lg:w-1/3">`);
  _push(ssrRenderComponent(_component_file_input, {
    modelValue: $data.form.logo_white,
    "onUpdate:modelValue": ($event) => $data.form.logo_white = $event,
    error: $data.form.errors.logo_white,
    class: "pr-2 w-full lg:w-3/5",
    type: "file",
    accept: "image/png",
    label: "Logo White"
  }, null, _parent));
  _push(`<div class="w-full lg:w-2/5 flex items-end justify-start">`);
  if ($data.form.main_logo_white) {
    _push(`<img class="block w-auto h-[30px] rounded bg-dark"${ssrRenderAttr("src", $data.form.main_logo_white)}>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div><div class="flex justify-start pb-8 w-full md:w-1/2 flex-col md:flex-row"><div class="font-bold text-sm mb-1 pr-6">${ssrInterpolate(_ctx.$t("Enable Registration"))}</div><div class="flex items-center mb-4"><input id="enableRegistration" type="checkbox"${ssrIncludeBooleanAttr(Array.isArray($data.form.enable_registration) ? ssrLooseContain($data.form.enable_registration, null) : $data.form.enable_registration) ? " checked" : ""} class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600"><label for="enableRegistration" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">${ssrInterpolate(_ctx.$t("Show Registration link on the login page"))}</label></div></div><div class="pb-8 pr-6 w-full"><label class="block text-sm font-bold text-gray-700 dark:text-gray-300 mb-2">${ssrInterpolate(_ctx.$t("Allowed File Types"))}</label><div class="flex flex-wrap gap-2 mb-2"><!--[-->`);
  ssrRenderList($data.form.allowed_file_types, (file_type, ft_key) => {
    _push(`<span class="inline-flex items-center rounded px-2 py-1 text-sm font-medium text-white bg-[#7366ff]">${ssrInterpolate(file_type)} <button type="button" class="inline-flex items-center p-1 ms-2 text-sm rounded-xs" aria-label="Remove">`);
    _push(ssrRenderComponent(_component_icon, {
      name: "close",
      class: "w-3 h-3 fill-white",
      "aria-hidden": "true"
    }, null, _parent));
    _push(`<span class="sr-only">Remove badge</span></button></span>`);
  });
  _push(`<!--]--></div><input${ssrRenderAttr("value", $data.newFileType)} class="w-full text-sm font-normal border border-gray-300 rounded px-3 py-2" type="text" placeholder="Type file type extensions you would like to allow and press enter or comma to add to the allowed list">`);
  if ($data.form.errors.allowed_file_types) {
    _push(`<div class="text-red-500 text-xs mt-1">${ssrInterpolate($data.form.errors.allowed_file_types)}</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div><div class="assigned_user pr-6 pb-8 w-full lg:w-full flex flex-col"><div class="font-bold text-sm mb-1">${ssrInterpolate(_ctx.$t("Email Notifications"))}</div></div><!--[-->`);
  ssrRenderList($data.form.email_notifications, (notification, ni) => {
    _push(`<div class="flex items-center justify-start pr-6 pb-8 w-full lg:w-1/3"><label${ssrRenderAttr("for", notification.slug)} class="flex toggle_swtich items-center cursor-pointer"><div class="flex items-center"><input${ssrRenderAttr("id", notification.slug)} type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(notification.value) ? ssrLooseContain(notification.value, null) : notification.value) ? " checked" : ""} class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600"><div class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">${ssrInterpolate(notification.name)}</div></div></label></div>`);
  });
  _push(`<!--]--><div class="assigned_user pr-6 pb-8 w-full lg:w-full flex flex-col"><div class="font-bold text-sm mb-1">${ssrInterpolate(_ctx.$t("Slack Notifications"))}</div></div><!--[-->`);
  ssrRenderList($data.form.slack_notifications, (notification, ni) => {
    _push(`<div class="flex items-center justify-start pr-6 pb-8 w-full lg:w-1/3"><label${ssrRenderAttr("for", "slack_" + notification.slug)} class="flex toggle_swtich items-center cursor-pointer"><div class="flex items-center"><input${ssrRenderAttr("id", "slack_" + notification.slug)} type="checkbox"${ssrIncludeBooleanAttr(Array.isArray(notification.value) ? ssrLooseContain(notification.value, null) : notification.value) ? " checked" : ""} class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600"><div class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300">${ssrInterpolate(notification.name)}</div></div></label></div>`);
  });
  _push(`<!--]--><div class="assigned_user pr-6 pb-8 w-full lg:w-full flex flex-col"><div class="font-bold text-sm mb-1">${ssrInterpolate(_ctx.$t("Cron Job Instruction"))}</div><div class="prose dark:prose-invert w-full"><p class="mt-2 font-light">If you would like to send mail without delaying you can set a cron job for that. To do that firstly you need to enable Queue with add <code>QUEUE_ENABLE=true</code> on the .env file. After that add a cronjob task as following.</p><code class="mt-5 mb-5 prose block whitespace-pre mt-1 text-sm">*/3 * * * * /usr/bin/php artisan queue:work --queue=high,default --stop-when-empty</code><small>On the above cron example, the cron will run every three(3) minutes to send mail based on Queue.</small><p class="mt-3 font-light">For the same thing if you would like to do on the cPanel or other shared hosting panel server you can add as like following</p><code class="mt-5 mb-5 prose block whitespace-pre mt-1 text-sm">*/3 * * * * wget -q -O - https://website.com/cron/queue_work &gt;/dev/null 2&gt;&amp;1</code></div></div>`);
  _push(ssrRenderComponent(_component_textarea_input, {
    modelValue: $data.form.custom_css,
    "onUpdate:modelValue": ($event) => $data.form.custom_css = $event,
    error: $data.form.errors.custom_css,
    rows: 15,
    class: "pb-6 w-full",
    placeholder: "your custom css here..",
    label: _ctx.$t("Custom CSS")
  }, null, _parent));
  _push(`</div><div class="px-8 py-4 bg-gray-50 border-t border-gray-100 flex items-center">`);
  _push(ssrRenderComponent(_component_loading_button, {
    loading: $data.form.processing,
    class: "btn-indigo ml-auto",
    type: "submit"
  }, {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
      } else {
        return [
          createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
        ];
      }
    }),
    _: 1
  }, _parent));
  _push(`</div></form></div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Settings/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Index = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  Index as default
};
