import { Head, Link } from "@inertiajs/vue3";
import { a as InviteWorkspaceMember, b as CreateProject, I as Icon, L as Layout } from "./Layout-p-cBGERf.js";
import { P as Pagination } from "./Pagination-DBkwUgAS.js";
import { B as BoardViewMenu } from "./BoardViewMenu-DKT5LdJ5.js";
import moment from "moment";
import { S as SearchInput } from "./SearchInput-DlyU-0R8.js";
import mapValues from "lodash/mapValues.js";
import throttle from "lodash/throttle.js";
import pickBy from "lodash/pickBy.js";
import axios from "axios";
import { resolveComponent, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./FlashMessages-DizfipYZ.js";
import "@popperjs/core";
import "uuid";
import "moment-duration-format";
import "laravel-vue-i18n";
const _sfc_main = {
  components: {
    InviteWorkspaceMember,
    CreateProject,
    Head,
    Icon,
    Link,
    BoardViewMenu,
    Pagination,
    SearchInput
  },
  layout: Layout,
  props: {
    title: String,
    auth: Object,
    projects: Object,
    workspace: Object,
    team_members: Object,
    filters: Object
  },
  data() {
    return {
      invite_workspace: false,
      form: {
        search: ""
      }
    };
  },
  watch: {
    form: {
      deep: true,
      handler: throttle(function() {
        this.$inertia.get(this.route("workspace.members", this.workspace.slug || this.workspace.id), pickBy(this.form), { preserveState: true });
      }, 150)
    }
  },
  computed: {},
  created() {
    this.moment = moment;
  },
  methods: {
    reset() {
      this.form = mapValues(this.form, () => null);
    },
    closeInviteMember() {
      this.invite_workspace = false;
      this.reset();
    },
    deleteMember(member, index) {
      this.team_members.data.splice(index, 1);
      axios.post(this.route("json.workspace.member.add"), { workspace_id: this.workspace.id, user_id: member.user_id });
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Head = resolveComponent("Head");
  const _component_icon = resolveComponent("icon");
  const _component_invite_workspace_member = resolveComponent("invite-workspace-member");
  const _component_search_input = resolveComponent("search-input");
  const _component_pagination = resolveComponent("pagination");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "h-full" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_Head, {
    title: _ctx.$t($props.title)
  }, null, _parent));
  _push(`<div class="flex task__time_logs flex-col task__table h-[calc(100%-52px)] overflow-hidden overflow-y-auto"><div class="min-w-full py-4 align-middle md:px-3 lg:px-4"><div class="flex justify-around items-center pt-3"><div class="flex"><div class="p-3 flex gap-2 items-center relative"><div class="logo flex justify-center items-center w-9 h-9 rounded-full bg-indigo-600 text-white text-lg">${ssrInterpolate($props.workspace.name.charAt(0))}</div><div class="name">${ssrInterpolate($props.workspace.name)}</div></div></div><div class="flex relative">`);
  if ($props.workspace.member.role === "admin") {
    _push(`<button class="flex gap-[5px] bg-indigo-600 h-9 items-center text-white rounded px-3">`);
    _push(ssrRenderComponent(_component_icon, {
      name: "user_plus",
      class: "w-4 h-4 fill-white"
    }, null, _parent));
    _push(` ${ssrInterpolate(_ctx.$t("Invite Workspace members"))}</button>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.invite_workspace) {
    _push(ssrRenderComponent(_component_invite_workspace_member, {
      workspace: $props.workspace,
      onInviteMember: ($event) => $options.closeInviteMember(),
      top: "40px",
      left: "-10px"
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div><div class="flex px-2 w-full border-b my-5"></div><div class="flex justify-between items-center"><h2 class="text mb-1 px-2 text-[20px] font-medium">${ssrInterpolate(_ctx.$t("Team Members"))}</h2><div class="tiny__time__log__bar">`);
  _push(ssrRenderComponent(_component_search_input, {
    modelValue: $data.form.search,
    "onUpdate:modelValue": ($event) => $data.form.search = $event,
    class: "w-full max-w-md mr-4",
    onReset: $options.reset
  }, null, _parent));
  _push(`</div></div></div><div class="inline-block min-w-full py-4 align-middle md:px-3 lg:px-4"><div class="overflow-hidden border bg-white shadow-md rounded-lg border-gray-200 dark:border-gray-700 md:rounded-lg"><table class="w-full rounded-lg whitespace-nowrap min-w-max w-full table-auto"><thead><tr class="text-gray-600 text-sm text-left"><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("ID"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Member"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Role"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Created At"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Action"))}</th></tr></thead><tbody><!--[-->`);
  ssrRenderList($props.team_members.data, (member, member_index) => {
    _push(`<tr class="hover:bg-gray-100 focus-within:bg-gray-100"><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500">${ssrInterpolate(member.id)}</div></td><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500">`);
    if (member.photo) {
      _push(`<div class="block rounded-full h-6 w-6"><img class="h-full w-full border border-white rounded-full"${ssrRenderAttr("src", member.photo)}${ssrRenderAttr("alt", member.name)}></div>`);
    } else {
      _push(`<div class="block rounded-full h-6 w-6"><img class="h-full w-full border border-white rounded-full" src="/images/user.svg"${ssrRenderAttr("alt", member.name)}></div>`);
    }
    _push(`<div class="ml-1">${ssrInterpolate(member.name)}</div></div></td><td class="border-t"><div class="px-6 py-3 flex capitalize items-center focus:text-indigo-500">${ssrInterpolate(member.role)}</div></td><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500">${ssrInterpolate(_ctx.moment(member.created_at).format("MMM D, YYYY [at] h:mm a"))}</div></td><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500">`);
    if ($props.workspace.member.id !== member.id) {
      _push(ssrRenderComponent(_component_icon, {
        onClick: ($event) => $options.deleteMember(member, member_index),
        name: "trash",
        class: "cursor-pointer w-4 h-4"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    _push(`</div></td></tr>`);
  });
  _push(`<!--]-->`);
  if ($props.team_members.data.length === 0) {
    _push(`<tr><td class="border-t px-6 py-4" colspan="6">${ssrInterpolate(_ctx.$t("No time log found."))}</td></tr>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</tbody></table><div class="flex w-full px-3 pb-3">`);
  _push(ssrRenderComponent(_component_pagination, {
    class: "mt-1",
    links: $props.team_members.links
  }, null, _parent));
  _push(`</div></div></div></div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Workspaces/Members.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Members = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  Members as default
};
