import { Head, Link } from "@inertiajs/vue3";
import { a as InviteWorkspaceMember, b as CreateProject, I as Icon, S as SelectInput, L as Layout } from "./Layout-p-cBGERf.js";
import { P as Pagination } from "./Pagination-DBkwUgAS.js";
import { B as BoardViewMenu } from "./BoardViewMenu-DKT5LdJ5.js";
import moment from "moment";
import { S as SearchInput } from "./SearchInput-DlyU-0R8.js";
import axios from "axios";
import { D as DeleteConfirmation } from "./DeleteConfirmation-B5REE71A.js";
import { F as FileInput } from "./FileInput-PDHMJZ8j.js";
import { resolveComponent, resolveDirective, mergeProps, withCtx, openBlock, createBlock, Fragment, renderList, toDisplayString, createVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrGetDirectiveProps, ssrRenderAttr, ssrRenderList, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./FlashMessages-DizfipYZ.js";
import "@popperjs/core";
import "uuid";
import "moment-duration-format";
import "laravel-vue-i18n";
const _sfc_main = {
  components: {
    FileInput,
    DeleteConfirmation,
    InviteWorkspaceMember,
    CreateProject,
    Head,
    Icon,
    Link,
    BoardViewMenu,
    Pagination,
    SearchInput,
    SelectInput
  },
  layout: Layout,
  props: {
    title: String,
    auth: Object,
    projects: Object,
    workspace: Object,
    filters: Object
  },
  data() {
    return {
      create_project: false,
      delete_workspace_popup: false,
      edit_workspace_option: false,
      invite_workspace: false,
      show_more: false,
      types: [],
      form: this.$inertia.form({
        name: this.workspace.name,
        type_id: this.workspace.type_id,
        website: this.workspace.website,
        description: this.workspace.description,
        logo: null
      })
    };
  },
  computed: {},
  methods: {
    getDetails(text) {
      if (text && text.length > 50)
        text = text.substring(0, 50) + "...";
      return text;
    },
    deleteWorkspace() {
      this.$inertia.delete(this.route("workspace.destroy", this.workspace.id));
    },
    closeInviteMember() {
      this.invite_workspace = false;
      window.location.href = this.route("workspace.members", this.workspace.slug || this.workspace.id);
    },
    updateWorkspace() {
      this.form.post(this.route("workspace.update", this.workspace.id));
    },
    saveProject(e, project) {
      project.star = !project.star;
      e.preventDefault();
      axios.post(this.route("json.p.starred.save", project.id)).then((resp) => {
        window.location.reload();
      });
    },
    getWorkspaceTypes() {
      axios.post(this.route("json.workspace.types.get")).then((response) => {
        if (response.data) {
          this.types = response.data.types;
        }
      });
    }
  },
  created() {
    this.moment = moment;
    this.getWorkspaceTypes();
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Head = resolveComponent("Head");
  const _component_icon = resolveComponent("icon");
  const _component_invite_workspace_member = resolveComponent("invite-workspace-member");
  const _component_select_input = resolveComponent("select-input");
  const _component_file_input = resolveComponent("file-input");
  const _component_create_project = resolveComponent("create-project");
  const _component_Link = resolveComponent("Link");
  const _component_delete_confirmation = resolveComponent("delete-confirmation");
  const _directive_click_outside = resolveDirective("click-outside");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "h-full" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_Head, {
    title: _ctx.$t($props.title)
  }, null, _parent));
  _push(`<div class="flex workspace__view flex-col task__table overflow-hidden overflow-y-auto"><div class="min-w-full py-4 align-middle md:px-3 lg:px-4"><div class="flex justify-around relative items-center pt-3"><div class="flex"><div class="p-3 flex gap-2 items-center relative">`);
  if ($props.workspace.logo) {
    _push(`<div class="logo has_bg flex justify-center items-center w-9 h-9 rounded-full text-white text-lg" style="${ssrRenderStyle({ "background-image": "url(" + $props.workspace.logo + ")" })}"></div>`);
  } else {
    _push(`<div class="logo flex justify-center items-center w-9 h-9 rounded-full bg-indigo-600 text-white text-lg">${ssrInterpolate($props.workspace.name.charAt(0))}</div>`);
  }
  _push(`<div class="name">${ssrInterpolate($props.workspace.name)}</div></div></div><div class="flex relative">`);
  if ($props.workspace.member.role === "admin") {
    _push(`<button class="flex gap-[5px] bg-indigo-600 h-9 items-center text-white rounded px-3">`);
    _push(ssrRenderComponent(_component_icon, {
      name: "user_plus",
      class: "w-4 h-4 fill-white"
    }, null, _parent));
    _push(` ${ssrInterpolate(_ctx.$t("Invite Workspace members"))}</button>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.invite_workspace) {
    _push(ssrRenderComponent(_component_invite_workspace_member, {
      workspace: $props.workspace,
      onInviteMember: ($event) => $options.closeInviteMember(),
      top: "40px",
      left: "-10px"
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
  if ($props.workspace.member.role === "admin") {
    _push(`<button${ssrRenderAttrs(mergeProps({ class: "top-[50%] right-3 absolute show__more flex" }, ssrGetDirectiveProps(_ctx, _directive_click_outside, () => {
      $data.show_more = false;
    })))}>`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 w-4",
      name: "more"
    }, null, _parent));
    _push(`</button>`);
  } else {
    _push(`<!---->`);
  }
  if ($data.show_more) {
    _push(`<div class="absolute right-7 top-[50%] w-30 z-999 bg-gray-100"><button class="flex w-full items-center bg-gray-200 hover:bg-gray-300 px-3 py-2 text-xs font-medium focus:outline-none focus:ring-0">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "mr-2 h-4 w-4",
      name: "edit"
    }, null, _parent));
    _push(` Edit Workspace </button><button class="flex w-full items-center bg-gray-200 hover:bg-gray-300 px-3 py-2 text-xs font-medium focus:outline-none focus:ring-0">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "mr-2 h-4 w-4",
      name: "trash"
    }, null, _parent));
    _push(` Delete Workspace </button></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
  if ($data.edit_workspace_option) {
    _push(`<div class="z-[200] rounded-[8px] bg-white shadow overflow-hidden create__project"><div class="flex gap-3 flex-col py-3 px-5"><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Workspace name"))} *</div><input${ssrRenderAttr("value", $data.form.name)} class="rounded border" type="text" required="required" aria-required="true" autocomplete="off"></label></div><div class="flex"><label class="flex flex-col w-full text-left"><div>${ssrInterpolate(_ctx.$t("Workspace Type"))}</div>`);
    _push(ssrRenderComponent(_component_select_input, {
      modelValue: $data.form.type_id,
      "onUpdate:modelValue": ($event) => $data.form.type_id = $event,
      class: "mr-2 w-full"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<!--[-->`);
          ssrRenderList($data.types, (type, ti) => {
            _push2(`<option${ssrRenderAttr("value", type.id)}${_scopeId}>${ssrInterpolate(type.name)}</option>`);
          });
          _push2(`<!--]-->`);
        } else {
          return [
            (openBlock(true), createBlock(Fragment, null, renderList($data.types, (type, ti) => {
              return openBlock(), createBlock("option", {
                key: ti,
                value: type.id
              }, toDisplayString(type.name), 9, ["value"]);
            }), 128))
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`</label></div><div class="flex flex-col">`);
    _push(ssrRenderComponent(_component_file_input, {
      modelValue: $data.form.logo,
      "onUpdate:modelValue": ($event) => $data.form.logo = $event,
      class: "w-full",
      type: "file",
      accept: "image/*",
      label: "Workspace Logo"
    }, null, _parent));
    _push(`</div><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Website"))} <small>(${ssrInterpolate(_ctx.$t("optional"))})</small></div><input${ssrRenderAttr("value", $data.form.website)} class="rounded border" type="text" autocomplete="off"></label></div><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Workspace Description"))} <small>(${ssrInterpolate(_ctx.$t("optional"))})</small></div><textarea class="rounded border h-20" autocomplete="off">${ssrInterpolate($data.form.description)}</textarea></label></div><div class="flex gap-3 justify-between"><button class="bg-indigo-600 w-full text-white p-[9px] rounded disabled:opacity-50"${ssrIncludeBooleanAttr(!$props.workspace.name) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("Update"))} ${ssrInterpolate(_ctx.$t("Workspace"))}</button><button class="bg-indigo-600 w-full text-white p-[9px] rounded disabled:opacity-50">${ssrInterpolate(_ctx.$t("Cancel"))}</button></div></div></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`<div class="flex px-2 w-full border-b my-5"></div><h2 class="text mb-8 px-2 mt-6 text-[20px] font-medium">Projects</h2>`);
  if ($data.create_project) {
    _push(ssrRenderComponent(_component_create_project, {
      onCreateProject: ($event) => $data.create_project = false
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`<ul class="project__list">`);
  if (!!this.$page.props.auth.user.role.create_project) {
    _push(`<li class="w-full py-1 px-2"><button class="p-2 group flex w-full rounded justify-between bg-cover bg-[#091e420f] hover:bg-[#091e4224]"><div class="flex flex-col h-24 w-full justify-center text-[16px] font-bold text-[#172b4d]"> Create new project </div></button></li>`);
  } else {
    _push(`<!---->`);
  }
  _push(`<!--[-->`);
  ssrRenderList($props.projects, (project, project_index) => {
    _push(`<li class="w-full py-1 px-2">`);
    _push(ssrRenderComponent(_component_Link, {
      href: _ctx.route("projects.view.board", project.slug || project.id),
      style: [project.background ? { backgroundColor: project.background.bg, backgroundImage: "url(" + project.background.image + ")", backgroundSize: "cover" } : {}],
      class: "p__item group"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<div class="content"${_scopeId}><div class="element"${_scopeId}><div class="title"${_scopeId}>${ssrInterpolate(project.title)}</div><p class="details"${_scopeId}>${ssrInterpolate($options.getDetails(project.description))}</p></div><button class="flex w-7 h-7 items-center justify-center"${_scopeId}>`);
          if (!!project.star) {
            _push2(ssrRenderComponent(_component_icon, {
              name: "star",
              class: "w-5 h-5 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
            }, null, _parent2, _scopeId));
          } else {
            _push2(ssrRenderComponent(_component_icon, {
              name: "star",
              class: "w-5 h-5 opacity-0 text-white group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
            }, null, _parent2, _scopeId));
          }
          _push2(`</button></div>`);
        } else {
          return [
            createVNode("div", { class: "content" }, [
              createVNode("div", { class: "element" }, [
                createVNode("div", { class: "title" }, toDisplayString(project.title), 1),
                createVNode("p", { class: "details" }, toDisplayString($options.getDetails(project.description)), 1)
              ]),
              createVNode("button", {
                class: "flex w-7 h-7 items-center justify-center",
                onClick: ($event) => $options.saveProject($event, project)
              }, [
                !!project.star ? (openBlock(), createBlock(_component_icon, {
                  key: 0,
                  name: "star",
                  class: "w-5 h-5 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
                })) : (openBlock(), createBlock(_component_icon, {
                  key: 1,
                  name: "star",
                  class: "w-5 h-5 opacity-0 text-white group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
                }))
              ], 8, ["onClick"])
            ])
          ];
        }
      }),
      _: 2
    }, _parent));
    _push(`</li>`);
  });
  _push(`<!--]--></ul></div></div>`);
  if ($data.delete_workspace_popup) {
    _push(ssrRenderComponent(_component_delete_confirmation, {
      onPopup: ($event) => $data.delete_workspace_popup = false,
      onConfirm: ($event) => $options.deleteWorkspace(),
      details: "Deleting workspace will delete all of the projects including board list. Are you sure you want to delete this workspace?"
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Workspaces/View.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const View = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  View as default
};
